/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.client;

import fr.iglee42.evolvedmekanism.client.renderers.datas.CustomRenderData;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;

public final class CustomModelRenderer {
    private static final int BLOCK_STAGES = 1000;
    private static final Map<CustomRenderData, Float2ObjectMap<MekanismRenderer.Model3D>> cachedCenterData = new Object2ObjectOpenHashMap();

    private CustomModelRenderer() {
    }

    public static int getStage(FluidStack stack, int stages, double scale) {
        return CustomModelRenderer.getStage(MekanismUtils.lighterThanAirGas((FluidStack)stack), stages, scale);
    }

    public static int getStage(boolean gaseous, int stages, double scale) {
        if (gaseous) {
            return stages - 1;
        }
        return Math.min(stages - 1, (int)(scale * (double)(stages - 1)));
    }

    public static MekanismRenderer.Model3D getModel(CustomRenderData data, double scale) {
        float maxStages = Math.max(data.height * 1000.0f, 1.0f);
        float stage = data.height == 0.0f ? 1.0f : (data.isGaseous() ? maxStages : Math.min(maxStages, (float)((int)(scale * (double)maxStages))));
        return (MekanismRenderer.Model3D)cachedCenterData.computeIfAbsent(data, d -> new Float2ObjectOpenHashMap()).computeIfAbsent(stage, s -> new MekanismRenderer.Model3D().setTexture(data.getTexture()).xBounds(0.01f, data.length - 0.02f).yBounds(0.01f, data.height * (s / maxStages) - 0.02f).zBounds(0.01f, data.width - 0.02f));
    }

    public static float getActualHeight(MekanismRenderer.Model3D model) {
        return model.maxY + 0.02f;
    }

    public static void resetCachedModels() {
        cachedCenterData.clear();
    }
}

